
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodComponentClass : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void GetComponentClassValues_Pass()
		{
			DataTable dtTest = DAL.BloodComponentClass.GetComponentClassValues();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentClassValues_Fail()
		{
		}

		[Test]
		public void GetComponentRequirements_Pass()
		{
			DataTable dtTest = DAL.BloodComponentClass.GetComponentRequirements();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentRequirement.ComponentRequirementId), TABLES.ComponentRequirement.ComponentRequirementId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentRequirement.ComponentRequirementText), TABLES.ComponentRequirement.ComponentRequirementText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentRequirements_Fail()
		{
		}

		[Test]
		public void GetComponentClasses_Pass()
		{
			DataTable dtTest = DAL.BloodComponentClass.GetComponentClasses();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClassParameter.ComponentClassParameterGuid), TABLES.ComponentClassParameter.ComponentClassParameterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClassParameter.DivisionCode), TABLES.ComponentClassParameter.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClassParameter.OrderableIndicator), TABLES.ComponentClassParameter.OrderableIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClassParameter.SpecimenRequiredIndicator), TABLES.ComponentClassParameter.SpecimenRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClassParameter.MaximumTransfusionTime), TABLES.ComponentClassParameter.MaximumTransfusionTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.SortColumn), TABLES.ComponentClass.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.RowVersion), TABLES.ComponentClass.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentClasses_Fail()
		{
		}


	}
}
#endif





